/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd.core;

import jp.nyatla.nymmd.core.PmdBone;
import jp.nyatla.nymmd.struct.pmd.PMD_IK;
import jp.nyatla.nymmd.types.MmdMatrix;
import jp.nyatla.nymmd.types.MmdVector3;
import jp.nyatla.nymmd.types.MmdVector4;

public class PmdIK {
    private PmdBone m_pTargetBone;
    private PmdBone m_pEffBone;
    private int m_unCount;
    private double _fact;
    private int m_nSortVal;
    private PmdBone[] m_ppBoneList;
    private final MmdVector3[] _work_vector3 = MmdVector3.createArray(4);
    private final MmdVector4 _work_vector4 = new MmdVector4();
    private final MmdMatrix __update_matInvBone = new MmdMatrix();

    public PmdIK(PMD_IK pPMDIKData, PmdBone[] i_ref_bone_array) {
        this.m_pTargetBone = i_ref_bone_array[pPMDIKData.nTargetNo];
        this.m_pEffBone = i_ref_bone_array[pPMDIKData.nEffNo];
        this.m_unCount = pPMDIKData.unCount;
        this._fact = (double)pPMDIKData.fFact * Math.PI;
        this.m_nSortVal = pPMDIKData.punLinkNo[0];
        int number_of_ik_link = pPMDIKData.cbNumLink;
        this.m_ppBoneList = new PmdBone[number_of_ik_link];
        for (int i = 0; i < number_of_ik_link; ++i) {
            this.m_ppBoneList[i] = i_ref_bone_array[pPMDIKData.punLinkNo[i]];
            if (!this.m_ppBoneList[i].getName().equals("\u5de6\u3072\u3056") && !this.m_ppBoneList[i].getName().equals("\u53f3\u3072\u3056")) continue;
            this.m_ppBoneList[i].setIKLimitAngle(true);
        }
    }

    private void limitAngle(MmdVector4 pvec4Out, MmdVector4 pvec4Src) {
        MmdVector3 vec3Angle = this._work_vector3[0];
        vec3Angle.QuaternionToEuler(pvec4Src);
        if ((double)vec3Angle.x < -Math.PI) {
            vec3Angle.x = (float)(-Math.PI);
        }
        if (-0.002f < vec3Angle.x) {
            vec3Angle.x = -0.002f;
        }
        vec3Angle.y = 0.0f;
        vec3Angle.z = 0.0f;
        pvec4Out.QuaternionCreateEuler(vec3Angle);
    }

    public int getSortVal() {
        return this.m_nSortVal;
    }

    public void update() {
        MmdMatrix matInvBone = this.__update_matInvBone;
        MmdVector3 vec3EffPos = this._work_vector3[0];
        MmdVector3 vec3TargetPos = this._work_vector3[1];
        MmdVector3 vec3Diff = this._work_vector3[2];
        MmdVector3 vec3RotAxis = this._work_vector3[3];
        MmdVector4 vec4RotQuat = this._work_vector4;
        for (int i = this.m_ppBoneList.length - 1; i >= 0; --i) {
            this.m_ppBoneList[i].updateMatrix();
        }
        this.m_pEffBone.updateMatrix();
        for (int it = this.m_unCount - 1; it >= 0; --it) {
            for (int j = 0; j < this.m_ppBoneList.length; ++j) {
                matInvBone.inverse(this.m_ppBoneList[j].m_matLocal);
                vec3EffPos.Vector3Transform(this.m_pEffBone.m_matLocal, matInvBone);
                vec3TargetPos.Vector3Transform(this.m_pTargetBone.m_matLocal, matInvBone);
                vec3Diff.Vector3Sub(vec3EffPos, vec3TargetPos);
                if (vec3Diff.Vector3DotProduct(vec3Diff) < (double)1.0E-7f) {
                    return;
                }
                vec3EffPos.Vector3Normalize(vec3EffPos);
                vec3TargetPos.Vector3Normalize(vec3TargetPos);
                double fRotAngle = Math.acos(vec3EffPos.Vector3DotProduct(vec3TargetPos));
                if (!(1.0E-8 < Math.abs(fRotAngle))) continue;
                if (fRotAngle < -this._fact) {
                    fRotAngle = -this._fact;
                } else if (this._fact < fRotAngle) {
                    fRotAngle = this._fact;
                }
                vec3RotAxis.Vector3CrossProduct(vec3EffPos, vec3TargetPos);
                if (vec3RotAxis.Vector3DotProduct(vec3RotAxis) < 1.0E-7) continue;
                vec3RotAxis.Vector3Normalize(vec3RotAxis);
                vec4RotQuat.QuaternionCreateAxis(vec3RotAxis, fRotAngle);
                if (this.m_ppBoneList[j].m_bIKLimitAngle) {
                    this.limitAngle(vec4RotQuat, vec4RotQuat);
                }
                vec4RotQuat.QuaternionNormalize(vec4RotQuat);
                this.m_ppBoneList[j].m_vec4Rotate.QuaternionMultiply(this.m_ppBoneList[j].m_vec4Rotate, vec4RotQuat);
                this.m_ppBoneList[j].m_vec4Rotate.QuaternionNormalize(this.m_ppBoneList[j].m_vec4Rotate);
                for (int i = j; i >= 0; --i) {
                    this.m_ppBoneList[i].updateMatrix();
                }
                this.m_pEffBone.updateMatrix();
            }
        }
    }
}

